/*================================================================================================================*/
// *********************************** THESE ARE THE INFORMATIONS OF THE MAP: *********************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

// THE PHILIPPINES WAR:
// CREATED BY DANY:
// FEBRUARY 2008:

/*================================================================================================================*/
// ********************************* MAIN ENTRY POINT FOR RANDOM MAP SCRIPT: ************************************ //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

include "mercenaries.xs";
include "ypAsianInclude.xs";
include "ypKOTHInclude.xs";

void main(void)
{

/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.01);
/*================================================================================================================*/
// *********************************** INITIALIZE THE MAP TYPE VARIABLES: *************************************** // 
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
  
        string nativeCiv1 = "Jesuit";
        string nativeCiv2 = "Sufi";
        
		string baseMix = "borneo_grass_a";
        string paintMix = "borneo_underbrush";
        string baseTerrain = "Deccan\ground_grass4_deccan";
        string seaType = "borneo coast";
        
		string startTreeType = "ypTreeBorneo";
        string forestType = "Borneo Forest";
        string forestType2 = "Borneo Palm Forest";
        
		string patchTerrain = "great_plains\ground2_gp";
        string patchType1 = "great_plains\ground8_gp";
        string patchType2 = "great_plains\ground7_gp";
        
		string mapType1 = "borneo";
        string mapType2 = "grass";
        
		string herdableType = "ypWaterBuffalo";
        string huntable1 = "ypSerow";
        string huntable2 = "ypWildElephant";
        
		string fish1 = "ypFishMolaMola";
        string fish2 = "ypFishTuna";
        string whale1 = "HumpbackWhale";
        
		string lightingType = "Borneo";
		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.05);
/*================================================================================================================*/
// ********************************** CHOOSES WHICH NATIVES APPEAR ON THE MAP: ********************************** //  
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
  
        int subCiv0=-1;
        int subCiv1=-1;
		
/*----------------------------------------------------------------------------------------------------------------*/		
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        if (rmAllocateSubCivs(2) == true)
    {
		// KLAMATH, COMANCHE, OR HURONS:
		subCiv0=rmGetCivID(nativeCiv1);
        if (subCiv0 >= 0)
        rmSetSubCiv(0, nativeCiv1);

		// CHEROKEE, APACHE, OR CHEYENNE:
		subCiv1=rmGetCivID(nativeCiv2);
        if (subCiv1 >= 0)
        rmSetSubCiv(1, nativeCiv2);
    }
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.10);
/*================================================================================================================*/
// ******************************************** PICKS THE MAP SIZE: ********************************************* //		
/*================================================================================================================*/

	    int playerTiles =40000;
	    
		if (cNumberNonGaiaPlayers >4)
		playerTiles = 40000;
	    if (cNumberNonGaiaPlayers >6)
		playerTiles = 40000;		

	    int size=2.0*sqrt(cNumberNonGaiaPlayers*playerTiles);
	    rmEchoInfo("Map size="+size+"m x "+size+"m");
	    // rmSetMapSize(size, size);
		   rmSetMapSize(800, 800);
		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.15);
/*================================================================================================================*/
// ***************************************** DEFINE THE MAP PARAMETERS: ***************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*================================================================================================================*/

	    // SET THE MAP ELEVATION PARAMETERS:
		rmSetMapElevationParameters(cElevTurbulence, 0.05, 10, 0.4, 7.0);
	    
		// SET THE MAP ELEVATION HEIGHT BLEND:
		rmSetMapElevationHeightBlend(1);
	
	    // SET THE SEA LEVEL:
		rmSetSeaLevel(1.0);
	    
		// SET THE LIGHTING:
		// rmSetLightingSet(lightingType);
		   rmSetLightingSet("Borneo");

	    // SET THE SEA TYPE:
		// rmSetSeaType(seaType);
		   rmSetSeaType("borneo coast");
	    
		// SET THE BASE TERRAIN MIX:
		// rmSetBaseTerrainMix(baseMix);
		   rmSetBaseTerrainMix("borneo_grass_a");
	    
		// THE TERRAIN INITIALIZATION:
		// rmTerrainInitialize(baseTerrain);
		   rmTerrainInitialize("water");
	    
		// SET THE MAP TYPE:
		// rmSetMapType(mapType1);
		   rmSetMapType("borneo");
	    // rmSetMapType(mapType2);
		   rmSetMapType("grass");
	    rmSetMapType("water");
	    
		// SET THE WORLD CIRCLE CONSTRAINT:
		rmSetWorldCircleConstraint(true);
	    
		// SET THE WIND MAGNITUDE:
		rmSetWindMagnitude(3.0);

	    // CHOOSE THE MERCS:
		chooseMercs();
		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.20);
/*================================================================================================================*/
// ************************ DEFINE SOME CLASSES: THESE ARE USED LATER FOR CONSTRAINTS: ************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
        
		int classPlayer=rmDefineClass("player");

/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.25);
/*================================================================================================================*/
// ******************************************* DEFINE THE CONSTRAINTS: ****************************************** //
// ************************** THESE ARE USED TO HAVE OBJECTS AND AREAS AVOID EACH OTHER: ************************ //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
    
	// MAP EDGE CONSTRAINTS:
//	int playerEdgeConstraint=rmCreatePieConstraint("player edge of map", 0.5, 0.5, 0, rmGetMapXSize()-18, 0, 0, 0);
//	int playerEdgeConstraint=rmCreateBoxConstraint("player edge of map", rmXTilesToFraction(6), rmZTilesToFraction(6), 1.0-rmXTilesToFraction(6), 1.0-rmZTilesToFraction(6), 0.01);
//  int playerEdgeConstraint=rmCreateBoxConstraint("player edge of map", rmXTilesToFraction(12), rmZTilesToFraction(12), 1.0-rmXTilesToFraction(12), 1.0-rmZTilesToFraction(12), 0.01);
	int playerEdgeConstraint=rmCreatePieConstraint("player edge of map", 0.5, 0.5, rmXFractionToMeters(0.0), rmXFractionToMeters(0.475), rmDegreesToRadians(0), rmDegreesToRadians(360));
  	
	// PLAYER CONSTRAINTS:
	int playerConstraint=rmCreateClassDistanceConstraint("stay away from players", rmClassID("player"), 8.0);
	
	// AVOID IMPASSABLE LAND:
    int impassableLandConstraint=rmCreateTerrainDistanceConstraint("stuff vs impassable land", "Land", false, 8.0);
  	int impassableLandMediumConstraint=rmCreateTerrainDistanceConstraint("medium vs impassable land", "Land", false, 15.0);
  	
	// CARDINAL DIRECTIONS:
    int Northward=rmCreatePieConstraint("northMapConstraint", 0.50, 0.50, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(315), rmDegreesToRadians(135));
    int Southward=rmCreatePieConstraint("southMapConstraint", 0.50, 0.50, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(135), rmDegreesToRadians(315));
    int Eastward=rmCreatePieConstraint("eastMapConstraint", 0.50, 0.50, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(45), rmDegreesToRadians(225));
    int Westward=rmCreatePieConstraint("westMapConstraint", 0.50, 0.50, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(225), rmDegreesToRadians(45));
			
	// DECORATION AVOIDANCE:
    int avoidAll=rmCreateTypeDistanceConstraint("avoid all", "all", 6.0); 

/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.30);
/*================================================================================================================*/
// ******************************************* DEFINE SOME OBJECTS: ********************************************* //
// ************************ THESE OBJECTS ARE ALL DEFINED SO THEY CAN BE PLACED LATER: ************************** //	
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.35);
/*================================================================================================================*/
// ************************************* DEFINE AND PLACE THE NORTH ISLAND: ************************************* //  
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // MAKE THE NORTH ISLAND:

	    int northIslandID=rmCreateArea("The North Island");
        
  	    rmSetAreaSize(northIslandID, 0.325, 0.325);
  
	    rmSetAreaCoherence(northIslandID, 1.0);
	    rmSetAreaBaseHeight(northIslandID, 3.0);
        rmSetAreaLocation(northIslandID, .80, .60);
	    rmSetAreaSmoothDistance(northIslandID, 20);
		
		// rmSetAreaMix(northIslandID, baseMix);
           rmSetAreaMix(northIslandID, "borneo_grass_a");
		
		rmAddAreaTerrainLayer(northIslandID, "borneo\ground_sand1_borneo", 0, 4);
        rmAddAreaTerrainLayer(northIslandID, "borneo\ground_sand2_borneo", 4, 6);
        rmAddAreaTerrainLayer(northIslandID, "borneo\ground_sand3_borneo", 6, 9);
        rmAddAreaTerrainLayer(northIslandID, "borneo\ground_grass4_borneo", 9, 12);
	    
		rmSetAreaObeyWorldCircleConstraint(northIslandID, false);
	    rmSetAreaElevationType(northIslandID, cElevTurbulence);
	    rmSetAreaElevationVariation(northIslandID, 4.0);
	    rmSetAreaElevationMinFrequency(northIslandID, 0.09);
	    rmSetAreaElevationOctaves(northIslandID, 3);
	    rmSetAreaElevationPersistence(northIslandID, 0.2);
	    rmSetAreaElevationNoiseBias(northIslandID, 1);

        // LENGHT OF PENINSULA:
        rmAddAreaInfluenceSegment(northIslandID, 0.60, 1.0, 0.45, 0.85);
        rmAddAreaInfluenceSegment(northIslandID, 0.80, 1.0, 0.50, 0.70);
        rmAddAreaInfluenceSegment(northIslandID, 0.90, 0.90, 0.60, 0.60);
        rmAddAreaInfluenceSegment(northIslandID, 1.00, 0.80, 0.70, 0.50);
        rmAddAreaInfluenceSegment(northIslandID, 1.00, 0.60, 0.85, 0.45);
  
        // POINT OF PENINSULA:
        rmAddAreaInfluenceSegment(northIslandID, 0.40, 1.00, 0.65, 0.65);
        rmAddAreaInfluenceSegment(northIslandID, 1.00, 0.40, 0.65, 0.65);
  
        // BACK OF ISLAND:
        rmAddAreaInfluenceSegment(northIslandID, 0.60, 1.00, 1.00, 0.60);

	    rmSetAreaWarnFailure(northIslandID, false);
	    rmBuildArea(northIslandID);
		
/*----------------------------------------------------------------------------------------------------------------*/

        // - ADD THE NORTH ISLANDS CONSTRAINTS: -
		
/*----------------------------------------------------------------------------------------------------------------*/		
        
		// - CONSTRAINT TO KEEP SOMETHING INSIDE AN AREA: -
		// int rmCreateAreaConstraint(string name,int areaID);
		// ex: int northIslandConstraint=rmCreateAreaConstraint("north Island", northIslandID);
		// That is making a constraint that forces something to remain within an area.
		int northIslandConstraint=rmCreateAreaConstraint("north Island", northIslandID);
		
		// - CONSTRAINT TO KEEP SOMETHING AWAY AN AREA: -
		// int rmCreateAreaDistanceConstraint(string name,int areaID,float distance);
		// ex:int avoidNorthIsland=rmCreateAreaDistanceConstraint("The north Island", northIslandID, 15);
		// that is making a constraint that force a minimum distance that an object 
		// or an area must stay from a specific area.
        int avoidNorthIsland=rmCreateAreaDistanceConstraint("The north Island", northIslandID, 15);

/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.40);
/*================================================================================================================*/
//	************************************* DEFINE AND PLACE THE SOUTH ISLAND: ************************************ //
/*================================================================================================================*/
		
		 // MAKE THE SOUTH ISLAND:

	    int southIslandID=rmCreateArea("The South Island");

        rmSetAreaSize(southIslandID, 0.325, 0.325);
  
	    rmSetAreaCoherence(southIslandID, 1.00);
	    rmSetAreaBaseHeight(southIslandID, 3.0);
        rmSetAreaLocation(southIslandID, .2, .2);
	    rmSetAreaSmoothDistance(southIslandID, 20);
	    
		// rmSetAreaMix(southIslandID, baseMix);
		   rmSetAreaMix(southIslandID, "borneo_grass_a");
        
		rmAddAreaTerrainLayer(southIslandID, "borneo\ground_sand1_borneo", 0, 4);
        rmAddAreaTerrainLayer(southIslandID, "borneo\ground_sand2_borneo", 4, 6);
        rmAddAreaTerrainLayer(southIslandID, "borneo\ground_sand3_borneo", 6, 9);
        rmAddAreaTerrainLayer(southIslandID, "borneo\ground_grass4_borneo", 9, 12);
	    
		rmSetAreaObeyWorldCircleConstraint(southIslandID, false);
	    rmSetAreaElevationType(southIslandID, cElevTurbulence);
	    rmSetAreaElevationVariation(southIslandID, 4.0);
	    rmSetAreaElevationMinFrequency(southIslandID, 0.09);
	    rmSetAreaElevationOctaves(southIslandID, 3);
	    rmSetAreaElevationPersistence(southIslandID, 0.2);
	    rmSetAreaElevationNoiseBias(southIslandID, 1);

        // LENGHT OF PENINSULA:
        rmAddAreaInfluenceSegment(southIslandID, 0.00, 0.40, 0.15, 0.55);
        rmAddAreaInfluenceSegment(southIslandID, 0.00, 0.20, 0.30, 0.50);
        rmAddAreaInfluenceSegment(southIslandID, 0.10, 0.10, 0.40, 0.40);
        rmAddAreaInfluenceSegment(southIslandID, 0.20, 0.00, 0.50, 0.30);
        rmAddAreaInfluenceSegment(southIslandID, 0.40, 0.00, 0.55, 0.15);
  
        // POINT OF PENINSULA:
        rmAddAreaInfluenceSegment(southIslandID, 0.00, 0.60, 0.35, 0.35);
        rmAddAreaInfluenceSegment(southIslandID, 0.60, 0.00, 0.35, 0.35);
  
        // BACK OF ISLAND:
        rmAddAreaInfluenceSegment(southIslandID, 0.00, 0.40, 0.40, 0.00);

	    rmSetAreaWarnFailure(southIslandID, false);
	    rmBuildArea(southIslandID);
		
/*----------------------------------------------------------------------------------------------------------------*/

        // ADD THE SOUTH ISLANDS CONSTRAINTS:
        int southIslandConstraint=rmCreateAreaConstraint("south Island", southIslandID);
        int avoidSouthIsland=rmCreateAreaDistanceConstraint("The south Island", southIslandID, 15); 		
        		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.425);
/*================================================================================================================*/
// ********************************** DEFINE AND PLACE THE NORTH TRADE ROUTE: *********************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
        
		// TRADE ROUTE AVOIDANCE:
	    int avoidTradeRoute = rmCreateTradeRouteDistanceConstraint("trade route", 6.0);
	    
	    // SOCKETS AVOIDANCE:
	    int avoidSocket=rmCreateTypeDistanceConstraint("stuff vs socket", "SocketTradeRoute", 12.0);
		
/*----------------------------------------------------------------------------------------------------------------*/		
				
		// THE NORTH TRADE ROUTE:
        int tradeRouteID = rmCreateTradeRoute();
        int socketID=rmCreateObjectDef("north trade route");
        rmSetObjectDefTradeRouteID(socketID, tradeRouteID);

        rmAddObjectDefItem(socketID, "SocketTradeRoute", 1, 0.0);
	    rmSetObjectDefAllowOverlap(socketID, true);
        rmSetObjectDefMinDistance(socketID, 0.0);
        rmSetObjectDefMaxDistance(socketID, 8.0);
		    
        rmAddTradeRouteWaypoint(tradeRouteID, 0.40, 0.95);
	    rmAddTradeRouteWaypoint(tradeRouteID, 0.95, 0.40);
		
/*----------------------------------------------------------------------------------------------------------------*/		
        	
     	bool placedTradeRoute = rmBuildTradeRoute(tradeRouteID, "water");
        if(placedTradeRoute == false)
        rmEchoError("Failed to place trade route");

/*----------------------------------------------------------------------------------------------------------------*/		
  
        // ADD THE SOCKETS ALONG THE TRADE ROUTE:
		vector socketLoc = rmGetTradeRouteWayPoint(tradeRouteID, 0.020);
        rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);
		
		socketLoc = rmGetTradeRouteWayPoint(tradeRouteID, 0.5);
        rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);
		
		socketLoc = rmGetTradeRouteWayPoint(tradeRouteID, .980);
        rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);
		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.45);
/*================================================================================================================*/
// ********************************** DEFINE AND PLACE THE SOUTH TRADE ROUTE: *********************************** //
/*================================================================================================================*/

        // THE SOUTH TRADE ROUTE:
	    int tradeRoute2ID = rmCreateTradeRoute();
        socketID=rmCreateObjectDef("south trade route");
        rmSetObjectDefTradeRouteID(socketID, tradeRoute2ID);
		
		rmAddObjectDefItem(socketID, "SocketTradeRoute", 1, 0.0);
        rmSetObjectDefAllowOverlap(socketID, true);
        rmSetObjectDefMinDistance(socketID, 0.0);
        rmSetObjectDefMaxDistance(socketID, 8.0);
		
		rmAddTradeRouteWaypoint(tradeRoute2ID, 0.05, 0.60);
        rmAddTradeRouteWaypoint(tradeRoute2ID, 0.60, 0.05);
		
/*----------------------------------------------------------------------------------------------------------------*/		
		
		placedTradeRoute = rmBuildTradeRoute(tradeRoute2ID, "water");
        if(placedTradeRoute == false)
        rmEchoError("Failed to place trade route");
		
/*----------------------------------------------------------------------------------------------------------------*/  
	  
	    // ADD THE SOCKETS ALONG THE TRADE ROUTE NUMBER 2:
        socketLoc = rmGetTradeRouteWayPoint(tradeRoute2ID, 0.020);
        rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);
		
		socketLoc = rmGetTradeRouteWayPoint(tradeRoute2ID, 0.500);
        rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);	

        socketLoc = rmGetTradeRouteWayPoint(tradeRoute2ID, 0.980);
        rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);		
		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.475);
/*================================================================================================================*/
// **************************************** SET UP THE PLAYER LOCATIONS ***************************************** //  
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
        
		if(rmRandFloat(0,1) > 0.50)
	{
		rmSetPlacementTeam(0);
		rmPlacePlayersLine(0.65, 0.85, 0.85, 0.65, 0, 0.0);

		rmSetPlacementTeam(1);
		rmPlacePlayersLine(0.35, 0.15, 0.15, 0.35, 0, 0.0);
	}
	    else
	{
		rmSetPlacementTeam(0);
		rmPlacePlayersLine(0.35, 0.15, 0.15, 0.35, 0, 0.0);
	
		rmSetPlacementTeam(1);
		rmPlacePlayersLine(0.65, 0.85, 0.85, 0.65, 0, 0.0);
	}
	
	
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.50);
/*================================================================================================================*/
// ***************************************** SET UP THE PLAYER AREAS: ******************************************* //
/*================================================================================================================*/

        float playerFraction=rmAreaTilesToFraction(3250);
		
/*----------------------------------------------------------------------------------------------------------------*/		
		
        for(i=1; <cNumberPlayers) 
	{
        // CREATE THE AREA:
		int id=rmCreateArea("Player"+i);
        
		// ASSIGN TO THE PLAYER:
		rmSetPlayerArea(i, id);
        
		// SET AREA SIZE:
		rmSetAreaSize(id, playerFraction, playerFraction);
        
		// ADD AREA TO CLASS:
		rmAddAreaToClass(id, classPlayer);
        
		// ADD AREA CONSTRAINT:
		//rmAddAreaConstraint(id, shortAvoidImportantItem); 
        //rmAddAreaConstraint(id, playerConstraint); 
        //rmAddAreaConstraint(id, playerEdgeConstraint); 
        
		// SET AREA COHERENCE:
		rmSetAreaCoherence(id, 1.0);
		
		// SET AREA TERRAIN TYPE:
		//rmSetAreaTerrainType(id, "carolina\marshflats");
		
		// SET AREA TERRAIN TYPE:
		//rmSetAreaTerrainType(id, "texas\ground2");

		// SET AREA MIX:
		//rmSetAreaMix(id, "rockies_snow");
		
		// SET AREA MIX:
		//rmSetAreaMix(id, "texas_dirt");
		
		// SET AREA MIX:
		//rmSetAreaMix(id, "rockies_grass");
	    
		// SET AREA BASE HEIGHT:
		//rmSetAreaBaseHeight(id, 18.0);
        
		// SET AREA LOC PLAYER:
		rmSetAreaLocPlayer(id, i);
        
		// SET AREA WARN FAILURE:
		rmSetAreaWarnFailure(id, true);
  }
	    // Build the areas.
        rmBuildAllAreas();
    
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.55);
/*================================================================================================================*/
// ************************************ DEFINE AND PLACE THE NATIVE TRIBES: ************************************* //    
/*================================================================================================================*/	
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        int nativesClass=rmDefineClass("natives");
	    int nativesConstraint=rmCreateClassDistanceConstraint("stuff vs natives", rmClassID("natives"), 15.0);
	    int importantItemClass=rmDefineClass("importantItem");
	    int importantItemConstraint=rmCreateClassDistanceConstraint("stuff vs importantItem", rmClassID("importantItem"), 15.0);

/*----------------------------------------------------------------------------------------------------------------*/        
		
		// ALWAYS AT LEAST TWO NATIVE VILLAGES OF EACH TYPE:
        if (subCiv0 == rmGetCivID(nativeCiv1)) 
	{  
     	int nativeVillage1Type = rmRandInt(1,5);
        int nativeVillage1ID = rmCreateGrouping("native village 1", "native sufi mosque borneo "+nativeVillage1Type);
        rmSetGroupingMinDistance(nativeVillage1ID, 0.0);
        rmSetGroupingMaxDistance(nativeVillage1ID, 0.0);
        rmAddGroupingToClass(nativeVillage1ID, rmClassID("natives"));
        //rmAddGroupingConstraint(nativeVillage1ID, avoidNatives);
                
		rmPlaceGroupingAtLoc(nativeVillage1ID, 0, 0.55, 0.95);		
    }	

        if (subCiv1 == rmGetCivID(nativeCiv2)) 
	{  
        int nativeVillage2Type = rmRandInt(1,5);
        int nativeVillage2ID = rmCreateGrouping("native village 2", "native jesuit mission borneo 0"+nativeVillage2Type);
        rmSetGroupingMinDistance(nativeVillage2ID, 0.0);
        rmSetGroupingMaxDistance(nativeVillage2ID, 0.0);
        rmAddGroupingToClass(nativeVillage2ID, rmClassID("natives"));
        //rmAddGroupingConstraint(nativeVillage2ID, avoidNatives);
                
		rmPlaceGroupingAtLoc(nativeVillage2ID, 0, 0.95, 0.55);			
    }  

/*----------------------------------------------------------------------------------------------------------------*/
	
        if (subCiv0 == rmGetCivID(nativeCiv1)) 
	{  
        nativeVillage1Type = rmRandInt(1,5);
        nativeVillage1ID = rmCreateGrouping("native village 1a", "native sufi mosque borneo "+nativeVillage1Type);
        rmSetGroupingMinDistance(nativeVillage1ID, 0.0);
        rmSetGroupingMaxDistance(nativeVillage1ID, 10.0);
        rmAddGroupingToClass(nativeVillage1ID, rmClassID("natives"));
        //rmAddGroupingConstraint(nativeVillage1ID, avoidNatives);
                
		rmPlaceGroupingAtLoc(nativeVillage1ID, 0, 0.05, 0.45);			
    }	

        if (subCiv1 == rmGetCivID(nativeCiv2)) 
   {  
        nativeVillage2Type = rmRandInt(1,5);
        nativeVillage2ID = rmCreateGrouping("native village 2a", "native jesuit mission borneo 0"+nativeVillage2Type);
        rmSetGroupingMinDistance(nativeVillage2ID, 0.0);
        rmSetGroupingMaxDistance(nativeVillage2ID, 10.0);
        rmAddGroupingToClass(nativeVillage2ID, rmClassID("natives"));
        //rmAddGroupingConstraint(nativeVillage2ID, avoidNatives);
                
		rmPlaceGroupingAtLoc(nativeVillage2ID, 0, 0.45, 0.05);			
    }  
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.60);
/*================================================================================================================*/
// ************************* DEFINE THE STARTING TCID AND STARTING UNITS AND RESOURCES: ************************* //
/*================================================================================================================*/
  
        // THE STARTING UNIT CLASS:
	    int classStartingUnit=rmDefineClass("startingUnit");
		
		// THE STARTING UNIT AVOIDANCE:
	    int startingUnitsConstraint=rmCreateClassDistanceConstraint("stuff vs starting units", rmClassID("startingUnit"), 8.0);

		// FRUITS AVOIDANCE:
	    int fruitsConstraint=rmCreateTypeDistanceConstraint("stuff vs fruits", "AbstractFruit", 15.0);
	    int fruitsMediumConstraint=rmCreateTypeDistanceConstraint("medium vs fruits", "AbstractFruit", 35.0);
	    int fruitsFarConstraint=rmCreateTypeDistanceConstraint("far vs fruits", "AbstractFruit", 65.0);
		
		// COIN AVOIDANCE:
	    int coinConstraint=rmCreateTypeDistanceConstraint("stuff vs coin", "AbstractMine", 15.0);
	    int coinMediumConstraint=rmCreateTypeDistanceConstraint("medium vs coin", "AbstractMine", 35.0);
	    int coinFarConstraint=rmCreateTypeDistanceConstraint("far vs coin", "AbstractMine", 65.0);
		
		// ypSerow AVOIDANCE:
	    int ypWaterBuffaloConstraint=rmCreateTypeDistanceConstraint("stuff vs ypWaterBuffalo", "ypWaterBuffalo", 15.0);
	    int ypWaterBuffaloMediumConstraint=rmCreateTypeDistanceConstraint("medium vs ypWaterBuffalo", "ypWaterBuffalo", 35.0);
	    int ypWaterBuffaloFarConstraint=rmCreateTypeDistanceConstraint("far vs ypWaterBuffalo", "ypWaterBuffalo", 65.0);
		
		// THE NUGGETS CLASS:
	    int classNugget=rmDefineClass("nugget");
		
		// THE NUGGETS AVOIDANCE:
	    int nuggetConstraint=rmCreateClassDistanceConstraint("stuff vs nugget", rmClassID("nugget"), 15.0);
	    int nuggetMediumConstraint=rmCreateClassDistanceConstraint("medium vs nugget", rmClassID("nugget"), 35.0);
	    int nuggetFarConstraint=rmCreateClassDistanceConstraint("far vs nugget", rmClassID("nugget"), 75.0);
		
		// THE TREES CLASS:
	    int classTree=rmDefineClass("tree");
		
	    // THE TREES AVOIDANCE:
	    int treeConstraint=rmCreateClassDistanceConstraint("stuff vs tree", rmClassID("tree"), 8.0);
        int treeMediumConstraint=rmCreateClassDistanceConstraint("medium vs tree", rmClassID("tree"), 25.0);
        int treeFarConstraint=rmCreateClassDistanceConstraint("far vs tree", rmClassID("tree"), 65.0);
		
		// FLAG CONSTRAINTS:
        int flagLand = rmCreateTerrainDistanceConstraint("flag vs land", "land", true, 15.0);
	    int flagVsFlag = rmCreateTypeDistanceConstraint("flag avoid same", "HomeCityWaterSpawnFlag", 15);
	    int flagEdgeConstraint=rmCreatePieConstraint("flag edge of map", 0.5, 0.5, 0, rmGetMapXSize()-10, 0, 0, 0);
		
/*----------------------------------------------------------------------------------------------------------------*/		
		
		// DEFINE THE STARTING TCID:
        int startingTCID= rmCreateObjectDef("startingTC");
	    if (rmGetNomadStart()) 
	{
		rmAddObjectDefItem(startingTCID, "CoveredWagon", 1, 0.0);
    }
		
        else 
	{
        rmAddObjectDefItem(startingTCID, "townCenter", 1, 0.0);
    }

        rmSetObjectDefMinDistance(startingTCID, 0.0);
	    rmSetObjectDefMaxDistance(startingTCID, 0.0);
		rmAddObjectDefToClass(startingTCID, rmClassID("startingUnit"));
	    //rmAddObjectDefConstraint(startingTCID, avoidImpassableLand);
	    rmAddObjectDefToClass(startingTCID, rmClassID("player"));
		
/*----------------------------------------------------------------------------------------------------------------*/

        // DEFINE THE STARTING UNITS:
		int startingUnits = rmCreateStartingUnitsObjectDef(5.0);
	    rmSetObjectDefMinDistance(startingUnits, 5.0);
        rmSetObjectDefMaxDistance(startingUnits, 10.0);
		rmAddObjectDefToClass(startingUnits, rmClassID("startingUnit"));
		rmAddObjectDefConstraint(startingUnits, startingUnitsConstraint);
		
/*----------------------------------------------------------------------------------------------------------------*/

        int playerCrateID=rmCreateObjectDef("bonus starting crates");
        rmAddObjectDefItem(playerCrateID, "crateOfFood", 2, 4.0);
        rmAddObjectDefItem(playerCrateID, "crateOfWood", 1, 0.0);
        rmAddObjectDefItem(playerCrateID, "crateOfCoin", 1, 0.0);
		rmAddObjectDefToClass(playerCrateID, rmClassID("startingUnit"));
        rmSetObjectDefMinDistance(playerCrateID, 5);
        rmSetObjectDefMaxDistance(playerCrateID, 14);
	    rmAddObjectDefConstraint(playerCrateID, startingUnitsConstraint);

/*----------------------------------------------------------------------------------------------------------------*/

        // DEFINE STARTING BERRIES:
		int StartBerriesID=rmCreateObjectDef("starting berries");
	    rmAddObjectDefItem(StartBerriesID, "berrybush", 5, 5.0);
		rmAddObjectDefToClass(StartBerriesID, rmClassID("startingUnit"));
	    rmSetObjectDefMinDistance(StartBerriesID, 16);
	    rmSetObjectDefMaxDistance(StartBerriesID, 25);
	    rmAddObjectDefConstraint(StartBerriesID, startingUnitsConstraint);
        rmAddObjectDefConstraint(StartBerriesID, fruitsMediumConstraint);

/*----------------------------------------------------------------------------------------------------------------*/
	
        // DEFINE THE STARTING SILVER:
		int startSilverID = rmCreateObjectDef("player silver");
	    rmAddObjectDefItem(startSilverID, "mine", 1, 0);
		rmAddObjectDefToClass(startSilverID, rmClassID("startingUnit"));
	    rmSetObjectDefMinDistance(startSilverID, 16.0);
	    rmSetObjectDefMaxDistance(startSilverID, 25.0);
	    rmAddObjectDefConstraint(startSilverID, startingUnitsConstraint);
	    rmAddObjectDefConstraint(startSilverID, fruitsConstraint);
        rmAddObjectDefConstraint(startSilverID, coinMediumConstraint);

/*----------------------------------------------------------------------------------------------------------------*/

        // DEFINE THE START ypSerow:
		int StartYpWaterBuffaloID=rmCreateObjectDef("The Starting YpWaterBuffalo");
        // rmAddObjectDefItem(StartYpWaterBuffaloID, herdableType, 12, 10.0);
		   rmAddObjectDefItem(StartYpWaterBuffaloID, "ypWaterBuffalo", 8, 10.0);
        rmSetObjectDefMinDistance(StartYpWaterBuffaloID, 18.0);
        rmSetObjectDefMaxDistance(StartYpWaterBuffaloID, 25.0);
        rmSetObjectDefCreateHerd(StartYpWaterBuffaloID, false);
        rmAddObjectDefConstraint(StartYpWaterBuffaloID, startingUnitsConstraint);
        rmAddObjectDefConstraint(StartYpWaterBuffaloID, fruitsConstraint);
		rmAddObjectDefConstraint(StartYpWaterBuffaloID, coinConstraint);

/*----------------------------------------------------------------------------------------------------------------*/

        // DEFINE THE PLAYER NUGGET:
		int playerNuggetID=rmCreateObjectDef("player nugget");
        rmAddObjectDefItem(playerNuggetID, "nugget", 1, 0.0);
        rmAddObjectDefToClass(playerNuggetID, rmClassID("nugget"));
        rmAddObjectDefToClass(playerNuggetID, rmClassID("startingUnit"));
        rmSetObjectDefMinDistance(playerNuggetID, 20.0);
        rmSetObjectDefMaxDistance(playerNuggetID, 30.0);
        rmAddObjectDefConstraint(playerNuggetID, startingUnitsConstraint);
        rmAddObjectDefConstraint(playerNuggetID, fruitsConstraint);
		rmAddObjectDefConstraint(playerNuggetID, coinConstraint);
		rmAddObjectDefConstraint(playerNuggetID, nuggetMediumConstraint);
		rmAddObjectDefConstraint(playerNuggetID, ypWaterBuffaloConstraint);
		
/*----------------------------------------------------------------------------------------------------------------*/

        // DEFINE THE START AREA TREE:
		int StartAreaTreeID=rmCreateObjectDef("starting trees");
        // rmAddObjectDefItem(StartAreaTreeID, startTreeType, 8, 6.0);
		   rmAddObjectDefItem(StartAreaTreeID, "ypTreeBorneo", 8, 8.0);
		rmAddObjectDefToClass(StartAreaTreeID, rmClassID("startingUnit"));   
		rmAddObjectDefToClass(StartAreaTreeID, rmClassID("tree"));   
        rmSetObjectDefMinDistance(StartAreaTreeID, 34.0);
        rmSetObjectDefMaxDistance(StartAreaTreeID, 42.0);
        rmAddObjectDefConstraint(StartAreaTreeID, startingUnitsConstraint);
        rmAddObjectDefConstraint(StartAreaTreeID, nuggetConstraint);
        rmAddObjectDefConstraint(StartAreaTreeID, fruitsConstraint);
		rmAddObjectDefConstraint(StartAreaTreeID, coinConstraint);
		rmAddObjectDefConstraint(StartAreaTreeID, treeMediumConstraint);
		
/*----------------------------------------------------------------------------------------------------------------*/

        // THE VARIABLE FOR WATER SPAWN POINT:
		int waterSpawnPointID = 0;		
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.65);
/*================================================================================================================*/
// ************************** PLACE THE STARTING TCID AND STARTING UNITS AND RESOURCES: ************************* //  
/*================================================================================================================*/
  
        // CLEAR THE CLOSEST POINT CONSTRAINTS:
		rmClearClosestPointConstraints();

	    for(i=1; < cNumberPlayers) 
{
		int placedTC = rmPlaceObjectDefAtLoc(startingTCID, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		vector TCLocation=rmGetUnitPosition(rmGetUnitPlacedOfPlayer(startingTCID, i));
		rmPlaceObjectDefAtLoc(startingUnits, i, rmXMetersToFraction(xsVectorGetX(TCLocation)), rmZMetersToFraction(xsVectorGetZ(TCLocation)));

		// PLACE THE PLAYER CRATES:
		rmPlaceObjectDefAtLoc(playerCrateID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// PLACE THE START BERRIES:
		rmPlaceObjectDefAtLoc(StartBerriesID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
        rmPlaceObjectDefAtLoc(StartBerriesID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
       
		// PLACE THE START SILVER:
		rmPlaceObjectDefAtLoc(startSilverID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(startSilverID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		
		// PLACE THE START YPWATERBUFFALO:
		rmPlaceObjectDefAtLoc(StartYpWaterBuffaloID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		
		// PLACE A NUGGET FOR THE PLAYER:
        rmSetNuggetDifficulty(1, 1);
        rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
        rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

        rmSetNuggetDifficulty(2, 2);
        rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		
		// PLACE THE STARTING TREES:
        rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
        rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
        rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
        rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
        rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
        rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		
		// PLACE WATER SPAWN POINTS:
		waterSpawnPointID=rmCreateObjectDef("colony ship "+i);
		rmAddObjectDefItem(waterSpawnPointID, "HomeCityWaterSpawnFlag", 1, 10.0);
		rmAddClosestPointConstraint(flagVsFlag);
		rmAddClosestPointConstraint(flagLand);
        rmAddClosestPointConstraint(flagEdgeConstraint);
		vector closestPoint = rmFindClosestPointVector(TCLocation, rmXFractionToMeters(1.0));
		rmPlaceObjectDefAtLoc(waterSpawnPointID, i, rmXMetersToFraction(xsVectorGetX(closestPoint)), rmZMetersToFraction(xsVectorGetZ(closestPoint)));
     
        // PLACE A CARAVEL:
		int catamaranID=rmCreateObjectDef("Caravel"+i);
        rmAddObjectDefItem(catamaranID, "Caravel", 1, 0.0);
        rmPlaceObjectDefAtLoc(catamaranID, i, rmXMetersToFraction(xsVectorGetX(closestPoint)), rmZMetersToFraction(xsVectorGetZ(closestPoint)));
	
	    // CLEAR CLOSEST POINT CONSTRAINTS:
		rmClearClosestPointConstraints();

}

/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.70);
/*================================================================================================================*/
// *********************************** DEFINE AND PLACE THE NORTHERN FORESTS: *********************************** //
/*================================================================================================================*/

        int forestClass=rmDefineClass("classForest");
		int forestConstraint=rmCreateClassDistanceConstraint("forest vs. forest", rmClassID("classForest"), 15.0);
	    int forestMediumConstraint=rmCreateClassDistanceConstraint("medium vs. forest", rmClassID("classForest"), 65.0);

/*----------------------------------------------------------------------------------------------------------------*/
		
		int forestTreeID = 0;
		int failCount=0;
  
        if (cNumberNonGaiaPlayers <=2)
		int numTries = 8 * cNumberNonGaiaPlayers;
		else
		numTries = 4 * cNumberNonGaiaPlayers;
	
/*----------------------------------------------------------------------------------------------------------------*/

        // THE NORTHERN FORESTS:
		for (i=0; <numTries) 
{   
        int northForest = rmCreateArea("The Northern Forest"+i);
        rmSetAreaWarnFailure(northForest, false);
        rmSetAreaSize(northForest, rmAreaTilesToFraction(175), rmAreaTilesToFraction(350));
        rmAddAreaToClass(northForest, rmClassID("classForest"));
        
		// rmSetAreaForestType(northForest, forestType);
		   rmSetAreaForestType(northForest, "Borneo Forest");
        
		rmSetAreaForestDensity(northForest, 0.65);
        rmSetAreaForestClumpiness(northForest, 0.55);
        rmSetAreaForestUnderbrush(northForest, 0.0);
        rmSetAreaCoherence(northForest, 0.3);
        rmSetAreaSmoothDistance(northForest, 10);
        rmSetAreaObeyWorldCircleConstraint(northForest, false);
        
		rmAddAreaConstraint(northForest, playerConstraint);		
        rmAddAreaConstraint(northForest, playerEdgeConstraint);	
        rmAddAreaConstraint(northForest, forestMediumConstraint);			
        rmAddAreaConstraint(northForest, northIslandConstraint);
        rmAddAreaConstraint(northForest, avoidTradeRoute);
        rmAddAreaConstraint(northForest, avoidSocket);
        rmAddAreaConstraint(northForest, nativesConstraint);
		rmAddAreaConstraint(northForest, impassableLandConstraint);
		
        if(rmBuildArea(northForest) == false) 
	{
        // Stop trying once we fail 4 times in a row.
        failCount++;
        if(failCount==4)
        break;
    }
        else
        failCount=0; 
}
        failCount=0; 
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.725);
/*================================================================================================================*/
// *********************************** DEFINE AND PLACE THE SOUTHERN FORESTS: *********************************** //
/*================================================================================================================*/
  
        // THE SOUTHERN FORESTS:
		for (i=0; <numTries) 
{   
        int southForest = rmCreateArea("The Southern Forest"+i);
        rmSetAreaWarnFailure(southForest, false);
        rmSetAreaSize(southForest, rmAreaTilesToFraction(175), rmAreaTilesToFraction(350));
        rmAddAreaToClass(southForest, rmClassID("classForest"));
        
		// rmSetAreaForestType(southForest, forestType);
		   rmSetAreaForestType(southForest, "Borneo Forest");
	
		rmSetAreaForestDensity(southForest, 0.3);
        rmSetAreaForestClumpiness(southForest, 0.2);
        rmSetAreaForestUnderbrush(southForest, 0.0);
        rmSetAreaCoherence(southForest, 0.3);
        rmSetAreaSmoothDistance(southForest, 10);
        rmSetAreaObeyWorldCircleConstraint(southForest, false);
        
		rmAddAreaConstraint(southForest, playerConstraint);		
        rmAddAreaConstraint(southForest, playerEdgeConstraint);	
        rmAddAreaConstraint(southForest, forestMediumConstraint);			
        rmAddAreaConstraint(southForest, southIslandConstraint);
		rmAddAreaConstraint(southForest, avoidTradeRoute);
        rmAddAreaConstraint(southForest, avoidSocket);
        rmAddAreaConstraint(southForest, nativesConstraint);
		rmAddAreaConstraint(southForest, impassableLandConstraint);
    
        if(rmBuildArea(southForest) == false) 
	{
        // Stop trying once we fail 4 times in a row.
        failCount++;
        if(failCount==4)
        break;
    }
        else
        failCount=0; 
}
 
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.75);
/*================================================================================================================*/
// *************************************** CHECK FOR THE KOTH GAME MODE: **************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        int avoidKOTH=rmCreateTypeDistanceConstraint("avoid KOTH", "ypKingsHill", 12.0);
		
/*----------------------------------------------------------------------------------------------------------------*/		
		
		if(rmGetIsKOTH()) 
	{
        int randLoc = rmRandInt(1,2);
        float xLoc = 0.5;
        float yLoc = 0.075;
        float walk = 0.025;
    
        ypKingsHillLandfill(xLoc, yLoc, .0075, 2.0, "borneo_sand_a", 0);
        ypKingsHillPlacer(xLoc, yLoc, walk, 0);
        rmEchoInfo("XLOC = "+xLoc);
        rmEchoInfo("XLOC = "+yLoc);
    }
  
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.775);
/*================================================================================================================*/
// ************************************ DEFINE AND PLACE THE SILVER MINES: ************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

	    int silverConstraint=rmCreateTypeDistanceConstraint("stuff vs silver", "AbstractMine", 15.0);
		int silverMediumConstraint=rmCreateTypeDistanceConstraint("medium vs silver", "AbstractMine", 35.0);
		int silverFarConstraint=rmCreateTypeDistanceConstraint("far vs silver", "AbstractMine", 65.0);
		
/*----------------------------------------------------------------------------------------------------------------*/
   
        // THE NORTHERN SILVER MINES:
        int silverID = rmCreateObjectDef("The Northern Silver Mines");
        rmAddObjectDefItem(silverID, "mine", 1, 0.0);
        rmSetObjectDefMinDistance(silverID, 0.0);
        rmSetObjectDefMaxDistance(silverID, rmXFractionToMeters(0.5));
        
		rmAddObjectDefConstraint(silverID, impassableLandConstraint);
        rmAddObjectDefConstraint(silverID, silverFarConstraint);
        rmAddObjectDefConstraint(silverID, playerConstraint);
		rmAddObjectDefConstraint(silverID, playerEdgeConstraint);
        rmAddObjectDefConstraint(silverID, nativesConstraint);
		rmAddObjectDefConstraint(silverID, forestConstraint);
		rmAddObjectDefConstraint(silverID, northIslandConstraint);
		rmAddObjectDefConstraint(silverID, avoidTradeRoute);
		rmAddObjectDefConstraint(silverID, avoidSocket);
				
		if (cNumberNonGaiaPlayers <=2)
	{	
	    rmPlaceObjectDefAtLoc(silverID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4.0);  
    } 
	    else
	{	
	    rmPlaceObjectDefAtLoc(silverID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2.0);
    } 
	
/*----------------------------------------------------------------------------------------------------------------*/
        
		// THE SOUTHERN SILVER MINES:
        int silver2ID = rmCreateObjectDef("The Southern Silver Mines");
        rmAddObjectDefItem(silver2ID, "mine", 1, 0.0);
        rmSetObjectDefMinDistance(silver2ID, 0.0);
        rmSetObjectDefMaxDistance(silver2ID, rmXFractionToMeters(0.5));
        
		rmAddObjectDefConstraint(silver2ID, impassableLandConstraint);
        rmAddObjectDefConstraint(silver2ID, silverFarConstraint);
        rmAddObjectDefConstraint(silver2ID, playerConstraint);
		rmAddObjectDefConstraint(silver2ID, playerEdgeConstraint);
        rmAddObjectDefConstraint(silver2ID, nativesConstraint);
		rmAddObjectDefConstraint(silver2ID, forestConstraint);
		rmAddObjectDefConstraint(silver2ID, southIslandConstraint);
		rmAddObjectDefConstraint(silver2ID, avoidTradeRoute);
		rmAddObjectDefConstraint(silver2ID, avoidSocket);
				
		if (cNumberNonGaiaPlayers <=2)
	{	
	    rmPlaceObjectDefAtLoc(silver2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4.0);  
    } 
	    else
	{	
	    rmPlaceObjectDefAtLoc(silver2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2.0);
    } 	
		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.80);
/*================================================================================================================*/
// ************************************** DEFINE AND PLACE THE TREASURES: *************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

	    // NUGGET CONSTRAINTS:
	    //int nuggetConstraint=rmCreateTypeDistanceConstraint("the stuff vs nugget", "AbstractNugget", 15.0);
		//int nuggetMediumConstraint=rmCreateTypeDistanceConstraint("The medium vs nugget", "AbstractNugget", 25.0);
	    //int nuggetFarConstraint=rmCreateTypeDistanceConstraint("the far vs nugget", "AbstractNugget", 65.0);
		
        // THE NUGGETS AVOIDANCE:
	    //int nuggetConstraint=rmCreateClassDistanceConstraint("stuff vs nugget", rmClassID("nugget"), 8.0);
	    //int nuggetMediumConstraint=rmCreateClassDistanceConstraint("medium vs nugget", rmClassID("nugget"), 35.0);
	    //int nuggetFarConstraint=rmCreateClassDistanceConstraint("far vs nugget", rmClassID("nugget"), 65.0);
		
/*----------------------------------------------------------------------------------------------------------------*/		
		
		// THE NORTHERN EASY NUGGETS:
	    int nuggetID= rmCreateObjectDef("The Northern Easy Nugget"); 
	    rmAddObjectDefItem(nuggetID, "Nugget", 1, 0.0);
		rmAddObjectDefToClass(nuggetID, rmClassID("nugget"));
	    rmSetNuggetDifficulty(1, 3);
	    rmSetObjectDefMinDistance(nuggetID, 0.0);
	    rmSetObjectDefMaxDistance(nuggetID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(nuggetID, nuggetFarConstraint);
		rmAddObjectDefConstraint(nuggetID, northIslandConstraint);
		rmAddObjectDefConstraint(nuggetID, forestConstraint);
		rmAddObjectDefConstraint(nuggetID, silverConstraint);
		rmAddObjectDefConstraint(nuggetID, avoidSocket);
		rmAddObjectDefConstraint(nuggetID, avoidTradeRoute);
	    rmAddObjectDefConstraint(nuggetID, nativesConstraint);
        rmAddObjectDefConstraint(nuggetID, playerConstraint);
		rmAddObjectDefConstraint(nuggetID, playerEdgeConstraint);
		rmAddObjectDefConstraint(nuggetID, impassableLandMediumConstraint);
		
		if (cNumberNonGaiaPlayers <=2)
	{	
		rmPlaceObjectDefAtLoc(nuggetID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);
	}
        else
	{
        rmPlaceObjectDefAtLoc(nuggetID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
	}

/*----------------------------------------------------------------------------------------------------------------*/

        // THE SOUTHERN EASY NUGGETS:
	    int nugget2ID= rmCreateObjectDef("The southern Easy Nugget"); 
	    rmAddObjectDefItem(nugget2ID, "Nugget", 1, 0.0);
		rmAddObjectDefToClass(nugget2ID, rmClassID("nugget"));
	    rmSetNuggetDifficulty(1, 3);
	    rmSetObjectDefMinDistance(nugget2ID, 0.0);
	    rmSetObjectDefMaxDistance(nugget2ID, rmXFractionToMeters(0.5));
	    				
		rmAddObjectDefConstraint(nugget2ID, nuggetFarConstraint);
		rmAddObjectDefConstraint(nugget2ID, southIslandConstraint);
		rmAddObjectDefConstraint(nugget2ID, forestConstraint);
		rmAddObjectDefConstraint(nugget2ID, silverConstraint);
		rmAddObjectDefConstraint(nugget2ID, avoidSocket);
		rmAddObjectDefConstraint(nugget2ID, avoidTradeRoute);
	    rmAddObjectDefConstraint(nugget2ID, nativesConstraint);
        rmAddObjectDefConstraint(nugget2ID, playerConstraint);
		rmAddObjectDefConstraint(nugget2ID, playerEdgeConstraint);
		rmAddObjectDefConstraint(nugget2ID, impassableLandMediumConstraint);
		   
		if (cNumberNonGaiaPlayers <=2)
	{	
		rmPlaceObjectDefAtLoc(nugget2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);
	}
        else
	{
        rmPlaceObjectDefAtLoc(nugget2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
	}
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.825);
/*================================================================================================================*/
// *********************************** DEFINE AND PLACE THE YPSEROW HERDS: ************************************** //
/*================================================================================================================*/

        // YPSEROW CONSTRAINTS:
	    int ypSerowConstraint=rmCreateTypeDistanceConstraint("stuff vs ypSerow", "ypSerow", 15.0);
		int ypSerowMediumConstraint=rmCreateTypeDistanceConstraint("medium vs ypSerow", "ypSerow", 25.0);
	    int ypSerowFarConstraint=rmCreateTypeDistanceConstraint("far vs ypSerow", "ypSerow", 65.0);
		
/*----------------------------------------------------------------------------------------------------------------*/		
	    		
		// THE NORTHERN YPSEROW HERDS:
        int ypSerowID=rmCreateObjectDef("The Northern YpSerow Herds");
	    rmAddObjectDefItem(ypSerowID, "ypSerow", rmRandInt(7,9), 6.0);
	    rmSetObjectDefMinDistance(ypSerowID, 0.0);
	    rmSetObjectDefMaxDistance(ypSerowID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(ypSerowID, ypSerowFarConstraint);
		rmAddObjectDefConstraint(ypSerowID, silverConstraint);
		rmAddObjectDefConstraint(ypSerowID, forestConstraint);
		rmAddObjectDefConstraint(ypSerowID, avoidTradeRoute);
		rmAddObjectDefConstraint(ypSerowID, avoidSocket);
	    rmAddObjectDefConstraint(ypSerowID, nativesConstraint);
		rmAddObjectDefConstraint(ypSerowID, nuggetConstraint);
		rmAddObjectDefConstraint(ypSerowID, playerConstraint);
		rmAddObjectDefConstraint(ypSerowID, playerEdgeConstraint);
		rmAddObjectDefConstraint(ypSerowID, northIslandConstraint);
		rmAddObjectDefConstraint(ypSerowID, impassableLandConstraint);
		
		if (cNumberNonGaiaPlayers <=2)
	{	
	    rmPlaceObjectDefAtLoc(ypSerowID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);  
    } 
	    else
	{	
	    rmPlaceObjectDefAtLoc(ypSerowID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
    }	
	
/*----------------------------------------------------------------------------------------------------------------*/

	    // THE SOUTHERN YPSEROW HERDS:
        int ypSerow2ID=rmCreateObjectDef("The Southern YpSerow Herds");
	    rmAddObjectDefItem(ypSerow2ID, "ypSerow", rmRandInt(7,9), 6.0);
	    rmSetObjectDefMinDistance(ypSerow2ID, 0.0);
	    rmSetObjectDefMaxDistance(ypSerow2ID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(ypSerow2ID, ypSerowFarConstraint);
		rmAddObjectDefConstraint(ypSerow2ID, silverConstraint);
		rmAddObjectDefConstraint(ypSerow2ID, forestConstraint);
		rmAddObjectDefConstraint(ypSerow2ID, avoidTradeRoute);
		rmAddObjectDefConstraint(ypSerow2ID, avoidSocket);
	    rmAddObjectDefConstraint(ypSerow2ID, nativesConstraint);
		rmAddObjectDefConstraint(ypSerow2ID, nuggetConstraint);
		rmAddObjectDefConstraint(ypSerow2ID, playerConstraint);
		rmAddObjectDefConstraint(ypSerow2ID, playerEdgeConstraint);
		rmAddObjectDefConstraint(ypSerow2ID, southIslandConstraint);
		rmAddObjectDefConstraint(ypSerow2ID, impassableLandConstraint);
			
		if (cNumberNonGaiaPlayers <=2)
	{	
	    rmPlaceObjectDefAtLoc(ypSerow2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*6);  
    } 
	    else
	{	
	    rmPlaceObjectDefAtLoc(ypSerow2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3);
    }	
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.85);
/*================================================================================================================*/
// *************************************** DEFINE AND PLACE THE BERRIES: **************************************** //        
/*================================================================================================================*/

		// FRUITS CONSTRAINTS:
	    //int fruitsConstraint=rmCreateTypeDistanceConstraint("the stuff vs fruits", "AbstractFruit", 15.0);
		//int fruitsMediumConstraint=rmCreateTypeDistanceConstraint("the medium vs fruits", "AbstractFruit", 40.0);
	    //int fruitsFarConstraint=rmCreateTypeDistanceConstraint("the far vs fruits", "AbstractFruit", 65.0);
		
/*----------------------------------------------------------------------------------------------------------------*/		
		
		// THE NORTHERN BERRIES:
		int berriesID=rmCreateObjectDef("The Northern Berries");
	    rmAddObjectDefItem(berriesID, "berrybush", rmRandInt(5,8), 5.0); 
	    rmSetObjectDefMinDistance(berriesID, 0.0);
	    rmSetObjectDefMaxDistance(berriesID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(berriesID, fruitsFarConstraint);
	    rmAddObjectDefConstraint(berriesID, ypSerowConstraint);
		rmAddObjectDefConstraint(berriesID, silverConstraint);
		rmAddObjectDefConstraint(berriesID, avoidTradeRoute);
		rmAddObjectDefConstraint(berriesID, avoidSocket);
		rmAddObjectDefConstraint(berriesID, forestConstraint);
		rmAddObjectDefConstraint(berriesID, nativesConstraint);
		rmAddObjectDefConstraint(berriesID, nuggetConstraint);
		rmAddObjectDefConstraint(berriesID, playerConstraint);
		rmAddObjectDefConstraint(berriesID, playerEdgeConstraint);
		rmAddObjectDefConstraint(berriesID, northIslandConstraint);
		rmAddObjectDefConstraint(berriesID, impassableLandConstraint);
				
		if (cNumberNonGaiaPlayers <=2)
	{	
	    rmPlaceObjectDefAtLoc(berriesID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);  
    } 
	    else
	{	
	    rmPlaceObjectDefAtLoc(berriesID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
    }
	
/*----------------------------------------------------------------------------------------------------------------*/

        // THE SOUTHERN BERRIES:
		int berries2ID=rmCreateObjectDef("The Southern Berries");
	    rmAddObjectDefItem(berries2ID, "berrybush", rmRandInt(5,8), 5.0); 
	    rmSetObjectDefMinDistance(berries2ID, 0.0);
	    rmSetObjectDefMaxDistance(berries2ID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(berries2ID, fruitsFarConstraint);
	    rmAddObjectDefConstraint(berries2ID, ypSerowConstraint);
		rmAddObjectDefConstraint(berries2ID, silverConstraint);
		rmAddObjectDefConstraint(berries2ID, avoidTradeRoute);
		rmAddObjectDefConstraint(berries2ID, avoidSocket);
		rmAddObjectDefConstraint(berries2ID, forestConstraint);
		rmAddObjectDefConstraint(berries2ID, nativesConstraint);
		rmAddObjectDefConstraint(berries2ID, nuggetConstraint);
		rmAddObjectDefConstraint(berries2ID, playerConstraint);
		rmAddObjectDefConstraint(berries2ID, playerEdgeConstraint);
		rmAddObjectDefConstraint(berries2ID, southIslandConstraint);
		rmAddObjectDefConstraint(berries2ID, impassableLandConstraint);
		
		if (cNumberNonGaiaPlayers <=2)
	{	
	    rmPlaceObjectDefAtLoc(berries2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);  
    } 
	    else
	{	
	    rmPlaceObjectDefAtLoc(berries2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
    }
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.875);
/*================================================================================================================*/
// *********************************** DEFINE AND PLACE THE YPSEROW HERDS: ************************************** //
/*================================================================================================================*/

        // YPWILDELEPHANT CONSTRAINTS:
	    int ypWildElephantConstraint=rmCreateTypeDistanceConstraint("stuff vs ypWildElephant", "ypWildElephant", 15.0);
		int ypWildElephantMediumConstraint=rmCreateTypeDistanceConstraint("medium vs ypWildElephant", "ypWildElephant", 25.0);
	    int ypWildElephantFarConstraint=rmCreateTypeDistanceConstraint("far vs ypWildElephant", "ypWildElephant", 65.0);
		
/*----------------------------------------------------------------------------------------------------------------*/		
	    		
		// THE NORTHERN YPWILDELEPHANT HERDS:
        int ypWildElephantID=rmCreateObjectDef("The Northern YpWildElephant Herds");
	    rmAddObjectDefItem(ypWildElephantID, "ypWildElephant", rmRandInt(2,3), 6.0);
	    rmSetObjectDefMinDistance(ypWildElephantID, 0.0);
	    rmSetObjectDefMaxDistance(ypWildElephantID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(ypWildElephantID, ypWildElephantFarConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, ypSerowMediumConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, silverConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, forestConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, avoidTradeRoute);
		rmAddObjectDefConstraint(ypWildElephantID, avoidSocket);
	    rmAddObjectDefConstraint(ypWildElephantID, nativesConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, nuggetConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, playerConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, playerEdgeConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, northIslandConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, impassableLandConstraint);
		rmAddObjectDefConstraint(ypWildElephantID, fruitsConstraint);
	    
		if (cNumberNonGaiaPlayers <=2)
	{	
	    rmPlaceObjectDefAtLoc(ypWildElephantID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);  
    } 
	    else
	{	
	    rmPlaceObjectDefAtLoc(ypWildElephantID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
    }	
	
/*----------------------------------------------------------------------------------------------------------------*/

	    // THE SOUTHERN YPWILDELEPHANT HERDS:
        int ypWildElephant2ID=rmCreateObjectDef("The Southern YpWildElephant Herds");
	    rmAddObjectDefItem(ypWildElephant2ID, "ypWildelephant", rmRandInt(2,3), 6.0);
	    rmSetObjectDefMinDistance(ypWildElephant2ID, 0.0);
	    rmSetObjectDefMaxDistance(ypWildElephant2ID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(ypWildElephant2ID, ypWildElephantFarConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, ypSerowMediumConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, silverConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, forestConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, avoidTradeRoute);
		rmAddObjectDefConstraint(ypWildElephant2ID, avoidSocket);
	    rmAddObjectDefConstraint(ypWildElephant2ID, nativesConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, nuggetConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, playerConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, playerEdgeConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, southIslandConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, impassableLandConstraint);
		rmAddObjectDefConstraint(ypWildElephant2ID, fruitsConstraint);
			
		if (cNumberNonGaiaPlayers <=2)
	{	
	    rmPlaceObjectDefAtLoc(ypWildElephant2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);  
    } 
	    else
	{	
	    rmPlaceObjectDefAtLoc(ypWildElephant2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
    }		
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.90);
/*================================================================================================================*/
// *************************************** DEFINE AND PLACE THE WHALES: ***************************************** //
/*================================================================================================================*/    
        
	// WHALES CONSTRAINTS:
	int fishVsWhale=rmCreateTypeDistanceConstraint("fish vs whale", "HumpbackWhale", 10.0);
	// int whaleVsWhaleID=rmCreateTypeDistanceConstraint("whale vs whale", whale1, 45.0);
	   int whaleVsWhaleID=rmCreateTypeDistanceConstraint("whale vs whale", "HumpbackWhale", 90.0);
	int whaleLand = rmCreateTerrainDistanceConstraint("whale vs land", "land", true, 20.0);
    int whaleEdgeConstraint=rmCreatePieConstraint("whale vs edge of map", 0.5, 0.5, 0, rmGetMapXSize()-20, 0, 0, 0);

/*----------------------------------------------------------------------------------------------------------------*/
		
		// DEFINE AND PLACE THE WHALES:
		int whaleID=rmCreateObjectDef("whale");
        // rmAddObjectDefItem(whaleID, whale1, 1, 0.0);
		   rmAddObjectDefItem(whaleID, "HumpbackWhale", 1, 0.0);
        rmSetObjectDefMinDistance(whaleID, 0.0);
        rmSetObjectDefMaxDistance(whaleID, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(whaleID, whaleVsWhaleID);  
        rmAddObjectDefConstraint(whaleID, whaleEdgeConstraint);
        rmAddObjectDefConstraint(whaleID, whaleLand);
		
		if (cNumberNonGaiaPlayers <=2)
        rmPlaceObjectDefAtLoc(whaleID, 0, 0.5, 0.5, 4*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(whaleID, 0, 0.5, 0.5, 2*cNumberNonGaiaPlayers);
		
/*================================================================================================================*/		
// **************************************** DEFINE AND PLACE THE FISHES: **************************************** //  
/*================================================================================================================*/

    int fishVsNuggetWater=rmCreateTypeDistanceConstraint("fish vs NuggetWater", "AbstractNugget", 10.0);
	int avoidLand = rmCreateTerrainDistanceConstraint("ship avoid land", "land", true, 15.0);
    int nuggetVsFlag = rmCreateTypeDistanceConstraint("nugget v flag", "HomeCityWaterSpawnFlag", 8.0);
	int avoidNuggetWater=rmCreateTypeDistanceConstraint("nugget water vs nugget water", "AbstractNugget", 90.0);
	int nuggetWEdgeConstraint=rmCreatePieConstraint("nuggetW vs edge of map", 0.5, 0.5, 0, rmGetMapXSize()-20, 0, 0, 0);
	
/*----------------------------------------------------------------------------------------------------------------*/	
		
		// DEFINE AND PLACE THE WATER NUGGETS:
        int nuggetW= rmCreateObjectDef("The Nugget Water"); 
        rmAddObjectDefItem(nuggetW, "ypNuggetBoat", 1, 0.0);
        rmSetNuggetDifficulty(5, 5);
        rmSetObjectDefMinDistance(nuggetW, rmXFractionToMeters(0.0));
        rmSetObjectDefMaxDistance(nuggetW, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(nuggetW, avoidLand);
        rmAddObjectDefConstraint(nuggetW, avoidNuggetWater);
        rmAddObjectDefConstraint(nuggetW, nuggetVsFlag);
		rmAddObjectDefConstraint(nuggetW, nuggetWEdgeConstraint);
		
		if (cNumberNonGaiaPlayers <=2)
        rmPlaceObjectDefAtLoc(nuggetW, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);
		else
		rmPlaceObjectDefAtLoc(nuggetW, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);
		
/*================================================================================================================*/
// **************************************** DEFINE AND PLACE THE FISHES: **************************************** //
/*================================================================================================================*/
    
        // FISH & WHALE CONSTRAINTS:
        // int fishVsFishID=rmCreateTypeDistanceConstraint("fish v fish", fish1, 15.0);
           int fishVsFishID=rmCreateTypeDistanceConstraint("fish v fish", "ypFishMolaMola", 10.0);			
	    // int fishVsFish2ID=rmCreateTypeDistanceConstraint("fish v fish2", fish2, 15.0); 
		   int fishVsFish2ID=rmCreateTypeDistanceConstraint("fish v fish2", "ypFishTuna", 10.0); 
	    int fishLand = rmCreateTerrainDistanceConstraint("fish land", "land", true, 8.0);

/*----------------------------------------------------------------------------------------------------------------*/		
		
		// DEFINE AND PLACE THE FISH 1:
		int fishID=rmCreateObjectDef("fish 1");
        // rmAddObjectDefItem(fishID, fish1, 1, 0.0);
		   rmAddObjectDefItem(fishID, "ypFishMolaMola", 1, 0.0);
        rmSetObjectDefMinDistance(fishID, 0.0);
        rmSetObjectDefMaxDistance(fishID, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(fishID, fishVsFishID);
        rmAddObjectDefConstraint(fishID, fishLand);
		rmAddObjectDefConstraint(fishID, fishVsNuggetWater);
		rmAddObjectDefConstraint(fishID, fishVsWhale);
		
		if (cNumberNonGaiaPlayers <=2)
        rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, 10*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, 5*cNumberNonGaiaPlayers);
				
/*----------------------------------------------------------------------------------------------------------------*/		
    
        // DEFINE AND PLACE THE FISH 2:
		int fish2ID=rmCreateObjectDef("fish 2");
        // rmAddObjectDefItem(fish2ID, fish2, 1, 0.0);
		   rmAddObjectDefItem(fish2ID, "ypFishTuna", 1, 0.0);
        rmSetObjectDefMinDistance(fish2ID, 0.0);
        rmSetObjectDefMaxDistance(fish2ID, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(fish2ID, fishVsFish2ID);
        rmAddObjectDefConstraint(fish2ID, fishLand);
		rmAddObjectDefConstraint(fish2ID, fishVsNuggetWater);
		rmAddObjectDefConstraint(fish2ID, fishVsWhale);
		
		if (cNumberNonGaiaPlayers <=2)
        rmPlaceObjectDefAtLoc(fish2ID, 0, 0.5, 0.5, 10*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(fish2ID, 0, 0.5, 0.5, 5*cNumberNonGaiaPlayers);
		
/*----------------------------------------------------------------------------------------------------------------*/
		
  
        // EXTRA FISH FOR UNDER 5 PLAYERS:
        if (cNumberNonGaiaPlayers < 5) 
	{
        int fish3ID=rmCreateObjectDef("fish 3");
        // rmAddObjectDefItem(fish3ID, fish1, 1, 0.0);
		   rmAddObjectDefItem(fish3ID, "ypFishMolaMola", 1, 0.0);
        rmSetObjectDefMinDistance(fish3ID, 0.0);
        rmSetObjectDefMaxDistance(fish3ID, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(fish3ID, fishVsFishID);
		rmAddObjectDefConstraint(fish3ID, fishVsFish2ID);
        rmAddObjectDefConstraint(fish3ID, fishLand);
		rmAddObjectDefConstraint(fish3ID, fishVsNuggetWater);
		rmAddObjectDefConstraint(fish3ID, fishVsWhale);
		
        rmPlaceObjectDefAtLoc(fish3ID, 0, 0.5, 0.5, 15*cNumberNonGaiaPlayers);
    } 

/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
    rmSetStatusText("",0.95);
/*================================================================================================================*/
// ***************************************** STARTER SHIPMENT TRIGGERS: ***************************************** //
/*================================================================================================================*/

        for(i = 1; < cNumberPlayers) 
  {
        rmCreateTrigger("XP"+i);
        rmSwitchToTrigger(rmTriggerID("XP"+i));
        rmSetTriggerPriority(3); 
        rmSetTriggerActive(true);
        rmSetTriggerRunImmediately(true);
        rmSetTriggerLoop(false);
      
        rmAddTriggerCondition("Always");
    
        rmAddTriggerEffect("Grant Resources");
        rmSetTriggerEffectParamInt("PlayerID", i, false);
        rmSetTriggerEffectParam("ResName", "XP", false);
        rmSetTriggerEffectParam("Amount", "275", false);
  }	
    
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",1.00);
/*===============================================================================================================*/
}
/*===============================================================================================================*/
// ************************************** THIS IS THE END OF THE MAP: ****************************************** //
/*===============================================================================================================*/













